<?php
/**
 * @version		$Id: blog_item.php 17224 2010-05-23 09:14:11Z infograf768 $
 * @package		Joomla.Site
 * @subpackage	com_content
 * @copyright	Copyright (C) 2005 - 2009 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;
// Create a shortcut for params
$canEdit	= $this->item->params->get('access-edit');
$params =& $this->item->params;
$images = json_decode($this->item->images);
$app = JFactory::getApplication();
$templateparams =$app->getTemplate(true)->params;

JHtml::addIncludePath(JPATH_COMPONENT.DS.'helpers');

if ($params->get('access-view')) {
	$link = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid));
} else {
	$menu = JSite::getMenu();
	$active = $menu->getActive();
	$itemId = $active->id;
	$link1 = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId);
	$returnURL = JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug));
	$link = new JURI($link1);
	$link->setVar('return', base64_encode($returnURL));
}

$title = $this->escape($this->item->category_title);
$title = ($title) ? $title : JText::_('JGLOBAL_UNCATEGORISED');
$title_url = JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catid));
?>

<?php if ($this->item->state == 0) : ?>
<div class="system-unpublished">
<?php endif; ?>
	<div class="img-intro">
		<a href="<?php echo $link; ?>">
			<?php  if (isset($images->image_intro) and !empty($images->image_intro)) : ?>
				<?php $imgfloat = (empty($images->float_intro)) ? $params->get('float_intro') : $images->float_intro; ?>
				<div class="img-intro-<?php echo htmlspecialchars($imgfloat); ?>">
				<img width="284" height="304"
					<?php if ($images->image_intro_caption):
						echo 'class="caption"'.' title="' .htmlspecialchars($images->image_intro_caption) .'"';
					endif; ?>
					src="<?php echo htmlspecialchars($images->image_intro); ?>" alt="<?php echo htmlspecialchars($images->image_intro_alt); ?>"/>
				</div>
			<?php endif; ?>
		</a>
		
		<a href="<?php echo $title_url; ?>">
			<div class="category-circle">
				<?php 	$title = $this->escape($this->item->category_title); ?>
				<div><?php echo $title; ?></div>
			</div>
		</a>
	</div>

	<div class="summary">

		<?php if ($params->get('show_print_icon') || $params->get('show_email_icon') || $canEdit) : ?>
		<ul class="actions">
			<?php if ($params->get('show_print_icon')) : ?>
			<li class="print-icon">
				<?php echo JHtml::_('icon.print_popup', $this->item, $params); ?>
			</li>
			<?php endif; ?>
			<?php if ($params->get('show_email_icon')) : ?>
			<li class="email-icon">
				<?php echo JHtml::_('icon.email', $this->item, $params); ?>
			</li>
			<?php endif; ?>
			<?php if ($canEdit) : ?>
			<li class="edit-icon">
				<?php echo JHtml::_('icon.edit', $this->item, $params); ?>
			</li>
			<?php endif; ?>
		</ul>
		<?php endif; ?>

		<?php if (!$params->get('show_intro')) : ?>
			<?php echo $this->item->event->afterDisplayTitle; ?>
		<?php endif; ?>

		<?php echo $this->item->event->beforeDisplayContent; ?>

		<div class="article-info">

			<div class="article-description">

				<?php if ($params->get('show_parent_category') && $this->item->parent_id != 1) : ?>
					<?php $title = $this->escape($this->item->parent_title);
						$title = ($title) ? $title : JText::_('JGLOBAL_UNCATEGORISED');
						$url = '<a href="' . JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->parent_slug)) . '">' . $title . '</a>'; ?>
					<?php if ($params->get('link_parent_category') and $this->item->parent_slug) : ?>
						<?php echo JText::sprintf('COM_CONTENT_PARENT', $url); ?>
						<?php else : ?>
						<?php echo JText::sprintf('COM_CONTENT_PARENT', $title); ?>
					<?php endif; ?>
				<?php endif; ?>

				<?php if ($params->get('show_category')) : ?>
					<?php $url = '<a class="category" href="'.$title_url.'">'.$title.'</a>';?>
					<?php if ($params->get('link_category')) : ?>
						<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
						<?php else : ?>
						<?php echo JText::sprintf('COM_CONTENT_CATEGORY', $title); ?>
					<?php endif; ?>
				<?php endif; ?>

				<?php if ($params->get('show_author') && !empty($this->item->author )) : ?>
				<span class="author">
					<?php $author =  $this->item->author; ?>
					<?php $author = ($this->item->created_by_alias ? $this->item->created_by_alias : $author);?>
					<?php $author_link = JHtml::_('link', JRoute::_('index.php?option=com_contact&view=contact&id='.$this->item->contactid), $author, array('class' => 'createdby'));?>
					<?php if (!empty($this->item->contactid ) &&  $params->get('link_author') == true):?>
						<?php 	echo JText::sprintf('COM_CONTENT_WRITTEN_BY' , $author_link); ?>
					<?php else :?>
						<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', $author); ?>
					<?php endif; ?>
				</span>
				<?php endif; ?>

				<?php if ($params->get('show_create_date')) : ?>
					<time pubdate="">
					<?php echo JHtml::_('date', $this->item->created, JText::_('DATE_FORMAT_LC3')); ?>
					</time>
				<?php endif; ?>

				<?php if ($params->get('show_modify_date')) : ?>
					<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHtml::_('date', $this->item->modified, JText::_('DATE_FORMAT_LC1'))); ?>
				<?php endif; ?>

				<?php if ($params->get('show_publish_date')) : ?>
					<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE_ON', JHtml::_('date', $this->item->publish_up, JText::_('DATE_FORMAT_LC1'))); ?>
				<?php endif; ?>

				<?php if ($params->get('show_hits')) : ?>
					<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $this->item->hits); ?>
				<?php endif; ?>
			</div>

			<?php if ($params->get('show_title')) : ?>
			<div class="article-title smartphone-title">
				<h2>
					<?php if ($params->get('link_titles') && $params->get('access-view')) : ?>
						<a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid)); ?>">
						<?php echo $this->escape($this->item->title); ?></a>
					<?php else : ?>
						<?php echo $this->escape($this->item->title); ?>
					<?php endif; ?>
				</h2>
			</div>
			<?php endif; ?>

		</div>

		<div class="article-content">
			<a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($this->item->slug, $this->item->catid)); ?>" class="no-underline">
			<?php echo strip_tags($this->item->introtext); ?>
			</a>
		</div>

		<div class="article-footer">
			<?php if ($params->get('show_readmore') && $this->item->readmore) : ?>
			<a class="readmore-link chevron" href="<?php echo $link; ?>">
			<span>
				<?php if (!$params->get('access-view')) :
					echo JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');
				elseif ($readmore = $this->item->alternative_readmore) :
					echo $readmore;
					if ($params->get('show_readmore_title', 0) != 0) :
						echo JHtml::_('string.truncate', ($this->item->title), $params->get('readmore_limit'));
					endif;
				elseif ($params->get('show_readmore_title', 0) == 0) :
					echo JText::sprintf('COM_CONTENT_READ_MORE_TITLE');
				else :
					echo JText::_('COM_CONTENT_READ_MORE');
					echo JHtml::_('string.truncate', ($this->item->title), $params->get('readmore_limit'));
				endif; ?>
			</span>
			</a>
			<?php endif; ?>
			<?php echo $this->item->event->afterDisplayContent; ?>
		</div>
	</div>
<?php if ($this->item->state == 0) : ?>
</div>
<?php endif; ?>

<div class="item-separator"></div>

