<?php
/**
 * @version		$Id: default.php 17137 2010-05-17 07:00:07Z infograf768 $
 * @package		Joomla.Site
 * @subpackage	com_content
 * @copyright	Copyright (C) 2005 - 2010 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access
defined('_JEXEC') or die;

$images = json_decode($this->item->images);
$app = JFactory::getApplication();
$templateparams = $app->getTemplate(true)->params;
JHtml::addIncludePath(JPATH_COMPONENT.DS.'helpers');

// Create shortcut to parameters.
$params = $this->item->params;

?>
<?php if ($this->params->get('show_page_heading')!=0 or $this->params->get('show_category_title')): ?>
<div class="masthead">
	<hgroup>
		<h1>
			<?php echo $this->escape($this->params->get('page_heading')); ?>
			<?php if ($this->params->get('show_category_title'))
			{

				echo '<span class="subheading-category">'.$this->category->title.'</span>';
			}
			?>
		</h1>
		<h2>
			<?php //echo $this->category->description; ?>
		</h2>
	</hgroup>
</div>
<?php endif; ?>

<article class="full item-page<?php echo $params->get('pageclass_sfx')?>">

	<a href="" class="chevron left back">&lt;&nbsp;&nbsp;&nbsp;Back to&nbsp;posts</a>

	<?php if ($params->get('access-edit') ||  $params->get('show_print_icon') || $params->get('show_email_icon')) : ?>
		<ul class="actions">
		<?php if (!$this->print) : ?>
			<?php if ($params->get('show_print_icon')) : ?>
			<li class="print-icon">
				<?php echo JHtml::_('icon.print_popup',  $this->item, $params); ?>
			</li>
			<?php endif; ?>

			<?php if ($params->get('show_email_icon')) : ?>
			<li class="email-icon">
				<?php echo JHtml::_('icon.email',  $this->item, $params); ?>
			</li>
			<?php endif; ?>
			<?php if ($this->user->authorise('core.edit', 'com_content.article.'.$this->item->id)) : ?>
			<li class="edit-icon">
				<?php echo JHtml::_('icon.edit', $this->item, $params); ?>
			</li>
			<?php endif; ?>
		<?php else : ?>
			<li>
				<?php echo JHtml::_('icon.print_screen',  $this->item, $params); ?>
			</li>
		<?php endif; ?>
		</ul>
	<?php endif; ?>

	<?php  if (!$params->get('show_intro')) :
		echo $this->item->event->afterDisplayTitle;
	endif; ?>

	<?php echo $this->item->event->beforeDisplayContent; ?>

	<div class="article-info">

		<div class="article-description">
		<?php if ($params->get('show_parent_category') && $this->item->parent_slug != '1:root') : ?>
			<?php 	$title = $this->escape($this->item->parent_title);
					$url = '<a class="parent-category" href="'.JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->parent_slug)).'">'.$title.'</a>';?>
			<?php if ($params->get('link_parent_category') AND $this->item->parent_slug) : ?>
				<?php echo JText::sprintf('COM_CONTENT_PARENT', $url); ?>
				<?php else : ?>
				<?php echo JText::sprintf('COM_CONTENT_PARENT', $title); ?>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ($params->get('show_category')) : ?>
			<?php 	$title = $this->escape($this->item->category_title);
					$title = ($title) ? $title : JText::_('JGLOBAL_UNCATEGORISED');
					$url = '<a class="category" href="'.JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catslug)).'">'.$title.'</a>';?>
			<?php if ($params->get('link_category') and $this->item->catslug) : ?>
				<?php //echo JText::sprintf('COM_CONTENT_CATEGORY', $url); ?>
				<?php echo $url; ?>
				<?php else : ?>
				<?php //echo JText::sprintf('COM_CONTENT_CATEGORY', $title); ?>
				<?php echo $title; ?>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ($params->get('show_author') && !empty($this->item->author )) : ?>
		<span class="author">
			<?php $author =  $this->item->author; ?>
			<?php $author = ($this->item->created_by_alias ? $this->item->created_by_alias : $author);?>
			<?php $author_link = JHtml::_('link', JRoute::_('index.php?option=com_contact&view=contact&id='.$this->item->contactid), $author, array('class' => 'createdby'));?>
			<?php if (!empty($this->item->contactid ) &&  $params->get('link_author') == true):?>
				<?php 	echo JText::sprintf('COM_CONTENT_WRITTEN_BY' , $author_link); ?>
			<?php else :?>
				<?php echo JText::sprintf('COM_CONTENT_WRITTEN_BY', $author); ?>
			<?php endif; ?>
		</span>
		<?php endif; ?>

		<?php if ($params->get('show_create_date')) : ?>
			<time pubdate="">
			<?php echo JHtml::_('date', $this->item->created, JText::_('DATE_FORMAT_LC3')); ?>
			</time>
		<?php endif; ?>

		<?php if ($params->get('show_modify_date')) : ?>
			<?php echo JText::sprintf('COM_CONTENT_LAST_UPDATED', JHTML::_('date',$this->item->modified, JText::_('DATE_FORMAT_LC1'))); ?>
		<?php endif; ?>

		<?php if ($params->get('show_publish_date')) : ?>
			<?php echo JText::sprintf('COM_CONTENT_PUBLISHED_DATE', JHTML::_('date',$this->item->publish_up, JText::_('DATE_FORMAT_LC1'))); ?>
		<?php endif; ?>

		<?php if ($params->get('show_hits')) : ?>
				<dd class="hits">
				<?php echo JText::sprintf('COM_CONTENT_ARTICLE_HITS', $this->item->hits); ?>
				</dd>
		<?php endif; ?>
		 </div>

		<?php if ($params->get('show_title')|| $params->get('access-edit')) : ?>
		<div class="article-title">
			<h2>
			<?php if ($params->get('link_titles') && !empty($this->item->readmore_link)) : ?>
				<a href="<?php echo $this->item->readmore_link; ?>">
				<?php echo $this->escape($this->item->title); ?></a>
			<?php else : ?>
				<?php echo $this->escape($this->item->title); ?>
			<?php endif; ?>
			</h2>
		</div>
		<?php endif; ?>

	</div>

	<?php  if (isset($images->image_fulltext) and !empty($images->image_fulltext)) : ?>
	<figure>
		<?php $imgfloat = (empty($images->image_fulltext)) ? $params->get('image_fulltext') : $images->image_fulltext; ?>
		<div class="img-fulltext-<?php echo htmlspecialchars($imgfloat); ?>">
		<img width="557" height="592"
			<?php if ($images->image_fulltext_caption):
				echo 'class="caption"'.' title="' .htmlspecialchars($images->image_fulltext_caption) .'"';
			endif; ?>
			src="<?php echo htmlspecialchars($images->image_fulltext); ?>" alt="<?php echo htmlspecialchars($images->image_fulltext_alt); ?>"/>
		</div>
	</figure>
	<?php endif; ?>

	<div class="article-content">
	<?php if (isset ($this->item->toc)) : ?>
		<?php echo $this->item->toc; ?>
	<?php endif; ?>

	<?php echo $this->item->text; ?>
	</div>

	<a class="nav bottom" href="#top">Article</a>
</article>

<?php echo $this->item->event->afterDisplayContent; ?>