<?php
/**
 * @package		fwstore template from faresweb.net
 * @copyright	Copyright (C) 2009 - 2011 faresweb.net, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined('_JEXEC') or die;

// get params
$app				= JFactory::getApplication();
$doc				= JFactory::getDocument();

$templateParams		= $app->getTemplate(true)->params;
$templatelUrl 		= $this->baseurl. '/templates/' . $this->template;
$templateColor 		= $this->params->get('color');
$templateLogo		= $this->params->get('logo');

// check modules
$showArticle		= ((JRequest::getVar('option')=='com_content') && (JRequest::getVar('view')=='article'));
$showFeatured		= ((JRequest::getVar('option')=='com_content') && (JRequest::getVar('view')=='featured'));
$showBlog			= ((JRequest::getVar('option')=='com_content') && (JRequest::getVar('layout')=='blog'));

$showBreadcrumbs	= ($this->countModules('breadcrumbs'));
$showRightColumn	= ($this->countModules('position-2'));

$isDesktop			= true;

$googleAdsence		= (int)$templateParams->get('google-adsence-use', 0);

$headerstuff = $this->getHeadData();
$myJoomlaScripts = $headerstuff['scripts'];
$myJoomlaScript = $headerstuff['script'];
/*$headerstuff['scripts'] = array();
$this->setHeadData($headerstuff);*/
$this->_script = $this->_scripts = array();

?>
<?php echo '<?xml version="1.0" encoding="' . $this->_charset . '"?>'; ?>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>" >
	<head>
		<jdoc:include type="head" />
		<meta name="viewport" content="width=device-width; initial-scale=1.0">
		<link href="<?php echo $templatelUrl; ?>/css/fwstore.css" rel="stylesheet" type="text/css" />
		<!--[if lte IE 6]>
			<link href="<?php echo $templatelUrl; ?>/css/ieonly.css" rel="stylesheet" type="text/css" />
		<![endif]-->
		<!--[if IE 7]>
			<link href="<?php echo $templatelUrl; ?>/css/ie7only.css" rel="stylesheet" type="text/css" />
		<![endif]-->
		<!--[if lt IE 9]>
			<script type="text/javascript" src="<?php echo $templatelUrl; ?>/javascript/html5.js"></script>
		<![endif]-->
	</head>

	<body>

  		<header>
		
			<a class="logo" href="<?php echo $this->baseurl ?>/">
				<?php if ($templateLogo): ?>
					<img class="logo" height="42" width="149" src="<?php echo $this->baseurl ?>/<?php echo htmlspecialchars($templateLogo); ?>" alt="<?php echo htmlspecialchars($templateParams->get('sitetitle'));?>" />
				<?php else: ?>
					<?php echo $templateParams->get('sitetitle'); ?>
				<?php endif; ?>
			</a>
			<?php if ($templateParams->get('sitedescription') != NULL): ?>
			<span class="header-desc">
			<?php echo $templateParams->get('sitedescription');?>
			</span>
			<?php endif; ?>
			
			<div class="social">
				<?php if($templateParams->get('facebook') != NULL): ?>
				<a target="_blank" href="https://www.facebook.com/<?php echo $templateParams->get('facebook'); ?>">
					<div class="sprite facebook" title="Facebook" role="img"></div>
				</a>
				<?php endif; ?>
				<?php if($templateParams->get('twitter') != NULL): ?>
				<a target="_blank" href="https://twitter.com/<?php echo $templateParams->get('twitter'); ?>/">
					<div class="sprite twitter" title="Twitter" role="img"></div>
				</a>
				<?php endif; ?>
				<?php if($templateParams->get('google-plus') != NULL): ?>
				<a target="_blank" href="https://plus.google.com/<?php echo $templateParams->get('google-plus'); ?>/posts">
					<div class="sprite google-plus" title="g+" role="img"></div>
				</a>
				<?php endif; ?>
			</div>

			<div class="shortcut">
			
				<div class="smartphone-menu" onclick="btnClick()"><span>Menu</span></div>

				
				<jdoc:include type="modules" name="search" />

			</div>
			
			<nav id="hnav">
				<jdoc:include type="modules" name="nav-1" />
			</nav>
			
		</header>
		
		<div id="top">
			<jdoc:include type="modules" name="breadcrumbs" />
			<nav class="top-navigation">
				<jdoc:include type="modules" name="nav-2" />
			</nav>
		</div>

		<?php if( $googleAdsence == 1 || $googleAdsence == 3): ?>
		<div id="googleadgoeshere-1">
			<div class="googleadgoeshere"> </div>
			<div class="clr"></div>
		</div>
		<?php endif;?>

		<jdoc:include type="modules" name="position-1" style="xhtml" />

		<div class="content<?php echo $showRightColumn ? '' : '-full'; ?><?php echo $showBreadcrumbs ? '' : ' no-breadcrumbs'; ?>">
		
			<jdoc:include type="message" />

			<jdoc:include type="component" />
			
		</div>
		
		<?php if ($showRightColumn) : ?>
		<aside class="right">
			<jdoc:include type="modules" name="position-2" style="xhtml" />
		</aside>
		<?php endif;?>

		<footer>
		
			<nav>
				<jdoc:include type="modules" name="nav-3" />
			</nav>
			
			<span class="copyright">
				<?php echo $templateParams->get('copyright'); ?>
			</span>

		</footer>
	
		<?php if( $googleAdsence == 2 || $googleAdsence == 3): ?>
		<div id="googleadgoeshere-2">
			<div class="googleadgoeshere"> </div>
			<div class="clr"></div>
		</div>
		<?php endif;?>

		<jdoc:include type="modules" name="debug" />
		
		<?php foreach($myJoomlaScripts as $key => $script) {echo '<script type=\'text/javascript\' src=\''.$key.'\'></script>';} ?>
		
		<?php foreach($myJoomlaScript as $script) {echo '<script type=\'text/javascript\'>'.$script.'</script>';} ?>
		
		<script type="text/javascript">
			/*$$('.smartphone-menu').addEvent('click', function () {
				if ($('hnav').hasClass('show')) {
					$('hnav').removeClass('show');
					$$('.smartphone-menu').removeClass('pressed');
				} else {
					$('hnav').addClass('show');
					$$('.smartphone-menu').addClass('pressed');
				}
			});*/
			function getElementsByClassName(classname, elm, tag) {
				tag = tag || "*";
				elm = elm || document;
				var classElements = new Array();
				var pattern = new RegExp("\\b"+classname+"\\b");
				var els = elm.getElementsByTagName(tag);
				var elsLen = els.length;
				for (ii = 0, j = 0; ii < elsLen; ii++) {
					if ( pattern.test(els[ii].className) ) {
						classElements[j] = els[ii];
						j++;
					}
				}
				return classElements;
			}
			function hasClass(ele, cls) {
				return ele.className.match(new RegExp('(\\s|^)'+cls+'(\\s|$)'));
			}
			function addClass(ele, cls) {
				if (!this.hasClass(ele, cls)) ele.className += " "+cls;
			}
			function removeClass(ele, cls) {
				if (hasClass(ele, cls)) {
					var reg = new RegExp('(\\s|^)'+cls+'(\\s|$)');
					ele.className = ele.className.replace(reg,' ');
				}
			}
			function btnClick() {
				var btn = getElementsByClassName('smartphone-menu')[0];
				var hnav = document.getElementById('hnav');
				if (hasClass(hnav, 'show')) {
					removeClass(hnav, 'show');
					removeClass(btn, 'pressed');
				} else {
					addClass(hnav, 'show');
					addClass(btn, 'pressed');
				}
			}
			var inputbox  = getElementsByClassName('inputbox')[0];
			inputbox.onfocus = function() {
				var search = getElementsByClassName('search')[0];
				addClass(search, 'focus');
			}
			inputbox.onblur = function() {
				var search = getElementsByClassName('search')[0];
				removeClass(search, 'focus');
			}
		</script>

		<?php if( (int)$this->params->get('google-analytics-use', 0) == 1): ?>
		<script type="text/javascript">
			var _gaq = _gaq || [];
			_gaq.push(['_setAccount', 		'<?php echo $this->params->get('google-analytics-account');?>']);
			_gaq.push(['_setDomainName', 	'<?php echo $this->params->get('google-analytics-domain');?>']);
			(function() {
				var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
				ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
				var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
			})();
		</script>
		<?php endif; ?>

		<?php if( (int)$this->params->get('google-adsence-use', 0) != 0): ?>
		<!-- Google Adsence -->
		<div id="adsense" style="display:none;">
			<script type="text/javascript">
			<!--
				google_ad_client 	= "<?php echo $this->params->get('google-adsence-client', '');?>";
				google_ad_slot 		= "<?php echo $this->params->get('google-adsence-slot', '');?>";
				google_ad_width 	= <?php echo $this->params->get('google-adsence-width', 320);?>;
				google_ad_height 	= <?php echo $this->params->get('google-adsence-height', 50);?>;
			//-->
			</script>
			<script type="text/javascript" src="http://pagead2.googlesyndication.com/pagead/show_ads.js"></script>
		</div>
		
		<script type="text/javascript">
		(function($){
			$(document).ready(function () {
				try{
					var ads_top = $("#adsense").find("iframe");
					
					//This is where the ads will show when the page is first loaded
					$(ads_top).appendTo(".googleadgoeshere");
					$("#adsense").remove();

					$('div').live('pagehide',function(event, ui){
						//This is where the ads will show when a page transition
						$(ads_top).appendTo(".googleadgoeshere");
					});
				} catch(err) {
			    }
			});
		})(jQuery);
		</script>
		<!-- / Google Adsence -->
		<?php endif; ?>
	</body>
</html>
